/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.EnumerationLiteral;
import org.eclipse.uml2.Extension;
import org.eclipse.uml2.ExtensionEnd;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Stereotype;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.internal.operation.ProfileOperations;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class StereotypeOperations
extends UML2Operations {
    public static final String ANNOTATION_SOURCE__APPLIED_STEREOTYPES = "appliedStereotypes";
    public static final String ANNOTATION_SOURCE__STEREOTYPE = "stereotype";
    public static final String ANNOTATION_SOURCE__ENUMERATION_LITERAL = "enumerationLiteral";
    public static final String METACLASS_EXTENSION_ROLE_PREFIX = "base$";
    public static final String STEREOTYPE_EXTENSION_ROLE_PREFIX = "extension$";
    static /* synthetic */ java.lang.Class class$0;
    static /* synthetic */ java.lang.Class class$1;
    static /* synthetic */ java.lang.Class class$2;
    static /* synthetic */ java.lang.Class class$3;
    static /* synthetic */ java.lang.Class class$4;
    static /* synthetic */ java.lang.Class class$5;

    private StereotypeOperations() {
    }

    public static EClass getEClass(Stereotype stereotype, String version) {
        EPackage ePackage = ProfileOperations.getEPackage(stereotype.getProfile(), version);
        return ePackage == null ? null : (EClass)ePackage.getEClassifier(ProfileOperations.getEClassifierName(stereotype));
    }

    public static EObject getEObject(Stereotype stereotype, Element element) {
        Iterator contents = UML2Operations.getEAnnotation(ANNOTATION_SOURCE__APPLIED_STEREOTYPES, element).getContents().iterator();
        while (contents.hasNext()) {
            EObject eObject = (EObject)contents.next();
            if (stereotype != StereotypeOperations.getStereotype(eObject)) continue;
            return eObject;
        }
        return null;
    }

    public static Stereotype getStereotype(EObject eObject) {
        return eObject == null ? null : StereotypeOperations.getStereotype(eObject.eClass());
    }

    protected static Stereotype getStereotype(EClass eClass) {
        EAnnotation stereotypeEAnnotation = UML2Operations.getEAnnotation(ANNOTATION_SOURCE__STEREOTYPE, (EModelElement)eClass);
        return stereotypeEAnnotation.getReferences().isEmpty() ? null : (Stereotype)stereotypeEAnnotation.getReferences().get(0);
    }

    public static EnumerationLiteral getEnumerationLiteral(EEnumLiteral eEnumLiteral) {
        EAnnotation enumerationLiteralEAnnotation = UML2Operations.getEAnnotation(ANNOTATION_SOURCE__ENUMERATION_LITERAL, (EModelElement)eEnumLiteral);
        return enumerationLiteralEAnnotation.getReferences().isEmpty() ? null : (EnumerationLiteral)enumerationLiteralEAnnotation.getReferences().get(0);
    }

    public static Set getAllExtendedEClasses(Stereotype stereotype) {
        HashSet allExtendedEClasses = new HashSet();
        StereotypeOperations.getAllExtendedEClassesHelper(stereotype, allExtendedEClasses);
        return allExtendedEClasses;
    }

    protected static void getAllExtendedEClassesHelper(Stereotype stereotype, Set allExtendedEClasses) {
        Iterator ownedAttributes = stereotype.getOwnedAttributes().iterator();
        block8: while (ownedAttributes.hasNext()) {
            Property property = (Property)ownedAttributes.next();
            Type type = property.getType();
            java.lang.Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = java.lang.Class.forName("org.eclipse.uml2.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(type)) continue;
            java.lang.Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = java.lang.Class.forName("org.eclipse.uml2.Extension");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isInstance(property.getAssociation())) continue;
            EClassifier eClassifier = UML2Package.eINSTANCE.getEClassifier(type.getName());
            java.lang.Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz3.isInstance(eClassifier)) continue;
            Iterator eClasses = allExtendedEClasses.iterator();
            while (eClasses.hasNext()) {
                EClass eClass = (EClass)eClasses.next();
                if (((EClass)eClassifier).isSuperTypeOf(eClass)) continue block8;
            }
            allExtendedEClasses.add(eClassifier);
        }
        Iterator generalizations = stereotype.getGeneralizations().iterator();
        while (generalizations.hasNext()) {
            Classifier general = ((Generalization)generalizations.next()).getGeneral();
            java.lang.Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = java.lang.Class.forName("org.eclipse.uml2.Stereotype");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(general)) continue;
            StereotypeOperations.getAllExtendedEClassesHelper((Stereotype)general, allExtendedEClasses);
        }
    }

    public static Set getExtendedMetaclasses(Stereotype stereotype) {
        HashSet<Type> extendedMetaclasses = new HashSet<Type>();
        if (stereotype != null) {
            Iterator ownedAttributes = stereotype.getOwnedAttributes().iterator();
            while (ownedAttributes.hasNext()) {
                Property property = (Property)ownedAttributes.next();
                Type type = property.getType();
                java.lang.Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.uml2.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(type)) continue;
                java.lang.Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = java.lang.Class.forName("org.eclipse.uml2.Extension");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isInstance(property.getAssociation())) continue;
                extendedMetaclasses.add(type);
            }
        }
        return extendedMetaclasses;
    }

    public static void apply(Stereotype stereotype, Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        if (stereotype == null || StereotypeOperations.isApplied(stereotype, element) || !element.getApplicableStereotypes().contains(stereotype)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EClass eClass = StereotypeOperations.getEClass(stereotype, ProfileOperations.getAppliedVersion(stereotype.getProfile(), element.getNearestPackage()));
        UML2Operations.getOrCreateEAnnotation(ANNOTATION_SOURCE__APPLIED_STEREOTYPES, element).getContents().add((Object)eClass.getEPackage().getEFactoryInstance().create(eClass));
    }

    public static Extension createExtension(Stereotype stereotype, EClass eClass, boolean required) {
        if (stereotype == null || UML2Operations.isEmpty(stereotype.getName()) || stereotype.getProfile() == null) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (eClass == null) {
            throw new IllegalArgumentException(String.valueOf(eClass));
        }
        Iterator extendedEClasses = stereotype.getAllExtendedEClasses().iterator();
        while (extendedEClasses.hasNext()) {
            if (!eClass.isSuperTypeOf((EClass)extendedEClasses.next())) continue;
            throw new IllegalArgumentException(String.valueOf(eClass));
        }
        Class class_ = null;
        Iterator referencedMetaclasses = stereotype.getProfile().getReferencedMetaclasses().iterator();
        while (referencedMetaclasses.hasNext()) {
            Class referencedMetaclass = (Class)referencedMetaclasses.next();
            if (!eClass.getName().equals(referencedMetaclass.getName())) continue;
            class_ = referencedMetaclass;
            break;
        }
        if (class_ == null) {
            Iterator referencedMetamodels = stereotype.getProfile().getReferencedMetamodels().iterator();
            while (referencedMetamodels.hasNext()) {
                Type type = ((Model)referencedMetamodels.next()).getOwnedType(eClass.getName());
                java.lang.Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.uml2.Class");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(type)) continue;
                class_ = (Class)type;
                break;
            }
        }
        if (class_ == null) {
            throw new IllegalArgumentException(String.valueOf(eClass));
        }
        Extension extension = (Extension)stereotype.getPackage().createOwnedMember(UML2Package.eINSTANCE.getExtension());
        extension.setName(String.valueOf(class_.getName()) + '_' + stereotype.getName());
        ExtensionEnd extensionEnd = (ExtensionEnd)extension.createOwnedEnd(UML2Package.eINSTANCE.getExtensionEnd());
        extensionEnd.setName(STEREOTYPE_EXTENSION_ROLE_PREFIX + stereotype.getName());
        extensionEnd.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        extensionEnd.setType(stereotype);
        if (!required) {
            extensionEnd.createLowerValue(UML2Package.eINSTANCE.getLiteralInteger());
        }
        Property property = stereotype.createOwnedAttribute(UML2Package.eINSTANCE.getProperty());
        property.setName(METACLASS_EXTENSION_ROLE_PREFIX + class_.getName());
        property.setType(class_);
        property.setAssociation(extension);
        return extension;
    }

    public static Set getApplicableStereotypes(Element element) {
        HashSet<Stereotype> applicableStereotypes = new HashSet<Stereotype>();
        if (element == null || element.getNearestPackage() == null) {
            return applicableStereotypes;
        }
        Iterator allAppliedProfiles = element.getNearestPackage().getAllAppliedProfiles().iterator();
        while (allAppliedProfiles.hasNext()) {
            Profile profile = (Profile)allAppliedProfiles.next();
            String appliedVersion = ProfileOperations.getAppliedVersion(profile, element.getNearestPackage());
            Iterator ownedStereotypes = profile.getOwnedStereotypes().iterator();
            while (ownedStereotypes.hasNext()) {
                Stereotype stereotype = (Stereotype)ownedStereotypes.next();
                if (stereotype.isAbstract() || StereotypeOperations.getEClass(stereotype, appliedVersion) == null) continue;
                Iterator extendedEClasses = stereotype.getAllExtendedEClasses().iterator();
                while (extendedEClasses.hasNext()) {
                    if (!((EClass)extendedEClasses.next()).isInstance((Object)element)) continue;
                    applicableStereotypes.add(stereotype);
                }
            }
        }
        return applicableStereotypes;
    }

    public static Stereotype getApplicableStereotype(Element element, String qualifiedStereotypeName) {
        if (element == null || UML2Operations.isEmpty(qualifiedStereotypeName)) {
            return null;
        }
        Iterator applicableStereotypes = element.getApplicableStereotypes().iterator();
        while (applicableStereotypes.hasNext()) {
            Stereotype applicableStereotype = (Stereotype)applicableStereotypes.next();
            if (!qualifiedStereotypeName.equals(applicableStereotype.getQualifiedName())) continue;
            return applicableStereotype;
        }
        return null;
    }

    public static Set getAppliedStereotypes(Element element) {
        HashSet<Stereotype> appliedStereotypes = new HashSet<Stereotype>();
        if (element == null) {
            return appliedStereotypes;
        }
        Iterator allApplicableStereotypes = element.getApplicableStereotypes().iterator();
        while (allApplicableStereotypes.hasNext()) {
            Stereotype stereotype = (Stereotype)allApplicableStereotypes.next();
            if (!StereotypeOperations.isApplied(stereotype, element)) continue;
            appliedStereotypes.add(stereotype);
        }
        return appliedStereotypes;
    }

    public static Stereotype getAppliedStereotype(Element element, String qualifiedStereotypeName) {
        if (element == null || UML2Operations.isEmpty(qualifiedStereotypeName)) {
            return null;
        }
        Iterator appliedStereotypes = element.getAppliedStereotypes().iterator();
        while (appliedStereotypes.hasNext()) {
            Stereotype appliedStereotype = (Stereotype)appliedStereotypes.next();
            if (!qualifiedStereotypeName.equals(appliedStereotype.getQualifiedName())) continue;
            return appliedStereotype;
        }
        return null;
    }

    public static String getVersion(Stereotype stereotype) {
        if (stereotype == null) {
            return null;
        }
        return ProfileOperations.getVersion(stereotype.getProfile());
    }

    public static String getAppliedVersion(Stereotype stereotype, Element element) {
        if (StereotypeOperations.isApplied(stereotype, element)) {
            return ProfileOperations.getAppliedVersion(stereotype.getProfile(), element.getNearestPackage());
        }
        return null;
    }

    public static Object getValue(Stereotype stereotype, Element element, String propertyName) {
        if (stereotype == null || !StereotypeOperations.isApplied(stereotype, element)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (UML2Operations.isEmpty(propertyName)) {
            throw new IllegalArgumentException(String.valueOf(propertyName));
        }
        EClass eClass = StereotypeOperations.getEClass(stereotype, StereotypeOperations.getAppliedVersion(stereotype, element));
        EObject eObject = StereotypeOperations.getEObject(stereotype, element);
        String[] tokens = propertyName.split("::");
        int i = 0;
        int length = tokens.length;
        while (i < length) {
            int index;
            EStructuralFeature eStructuralFeature;
            block24: {
                block22: {
                    block23: {
                        String token = tokens[i];
                        eStructuralFeature = null;
                        index = -1;
                        if (-1 == token.indexOf(91)) {
                            eStructuralFeature = eClass.getEStructuralFeature(UML2Operations.getValidIdentifier(token));
                        } else {
                            eStructuralFeature = eClass.getEStructuralFeature(UML2Operations.getValidIdentifier(token.substring(0, token.indexOf(91))));
                            try {
                                index = Integer.parseInt(token.substring(token.indexOf(91) + 1, token.indexOf(93)));
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException(String.valueOf(propertyName));
                            }
                        }
                        if (eStructuralFeature == null) {
                            throw new IllegalArgumentException(String.valueOf(propertyName));
                        }
                        if (i + 1 >= length) break block22;
                        if (eObject == null) break block23;
                        java.lang.Class<?> clazz = class$2;
                        if (clazz == null) {
                            try {
                                clazz = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz.isInstance(eStructuralFeature.getEType())) break block24;
                    }
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                if (eObject == null && stereotype != StereotypeOperations.getStereotype(eClass)) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                Object value = null;
                if (eStructuralFeature.isMany()) {
                    List list = eObject == null ? Collections.EMPTY_LIST : (List)eObject.eGet(eStructuralFeature);
                    value = -1 == index ? list : list.get(index);
                } else {
                    Object object = value = eObject == null ? eStructuralFeature.getDefaultValue() : eObject.eGet(eStructuralFeature);
                }
                if (EcorePackage.eINSTANCE.getEEnum().isInstance((Object)eStructuralFeature.getEType())) {
                    java.lang.Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = class$4 = java.lang.Class.forName("org.eclipse.emf.ecore.EEnumLiteral");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.isInstance(value)) {
                        value = StereotypeOperations.getEnumerationLiteral((EEnumLiteral)value);
                    }
                }
                return value;
            }
            eClass = (EClass)eStructuralFeature.getEType();
            eObject = (EObject)(eStructuralFeature.isMany() ? ((List)eObject.eGet(eStructuralFeature)).get(index) : eObject.eGet(eStructuralFeature));
            ++i;
        }
        return null;
    }

    public static boolean isApplied(Stereotype stereotype, Element element) {
        if (stereotype == null || element == null) {
            return false;
        }
        Package nearestPackage = element.getNearestPackage();
        if (nearestPackage != null) {
            if (StereotypeOperations.getEObject(stereotype, element) != null) {
                return true;
            }
            String appliedVersion = nearestPackage.getAppliedVersion(stereotype.getProfile());
            if (appliedVersion != null) {
                return StereotypeOperations.isRequired(stereotype, element) && StereotypeOperations.getEClass(stereotype, appliedVersion) != null;
            }
        }
        return false;
    }

    public static boolean isRequired(Stereotype stereotype, Element element) {
        if (stereotype == null) {
            return false;
        }
        if (element == null) {
            return false;
        }
        Iterator ownedAttributes = stereotype.getOwnedAttributes().iterator();
        while (ownedAttributes.hasNext()) {
            Property property = (Property)ownedAttributes.next();
            java.lang.Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = java.lang.Class.forName("org.eclipse.uml2.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(property.getType())) continue;
            java.lang.Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = java.lang.Class.forName("org.eclipse.uml2.Extension");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz2.isInstance(property.getAssociation())) continue;
            EClassifier eClassifier = UML2Package.eINSTANCE.getEClassifier(property.getType().getName());
            java.lang.Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz3.isInstance(eClassifier) || !((EClass)eClassifier).isInstance((Object)element)) continue;
            return ((Extension)property.getAssociation()).isRequired();
        }
        return false;
    }

    public static void setValue(Stereotype stereotype, Element element, String propertyName, Object value) {
        if (stereotype == null || !StereotypeOperations.isApplied(stereotype, element)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        if (UML2Operations.isEmpty(propertyName)) {
            throw new IllegalArgumentException(String.valueOf(propertyName));
        }
        EClass eClass = StereotypeOperations.getEClass(stereotype, StereotypeOperations.getAppliedVersion(stereotype, element));
        EObject stereotypeEObject = StereotypeOperations.getEObject(stereotype, element);
        if (stereotypeEObject == null) {
            stereotypeEObject = eClass.getEPackage().getEFactoryInstance().create(eClass);
        }
        EObject eObject = stereotypeEObject;
        String[] tokens = propertyName.split("::");
        int i = 0;
        int length = tokens.length;
        while (i < length) {
            int j;
            List list;
            String token = tokens[i];
            EStructuralFeature eStructuralFeature = null;
            int index = -1;
            if (-1 == token.indexOf(91)) {
                eStructuralFeature = eClass.getEStructuralFeature(token);
            } else {
                eStructuralFeature = eClass.getEStructuralFeature(token.substring(0, token.indexOf(91)));
                try {
                    index = Integer.parseInt(token.substring(token.indexOf(91) + 1, token.indexOf(93)));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
            }
            if (eStructuralFeature == null) {
                throw new IllegalArgumentException(String.valueOf(propertyName));
            }
            if (i + 1 < length) {
                java.lang.Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isInstance(eStructuralFeature.getEType())) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                eClass = (EClass)eStructuralFeature.getEType();
                if (eStructuralFeature.isMany()) {
                    list = (List)eObject.eGet(eStructuralFeature);
                    j = list.size();
                    while (j <= index) {
                        list.add(j, eClass.getEPackage().getEFactoryInstance().create(eClass));
                        ++j;
                    }
                    eObject = (EObject)list.get(index);
                } else {
                    if (eObject.eGet(eStructuralFeature) == null) {
                        eObject.eSet(eStructuralFeature, (Object)eClass.getEPackage().getEFactoryInstance().create(eClass));
                    }
                    eObject = (EObject)eObject.eGet(eStructuralFeature);
                }
            } else {
                java.lang.Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = java.lang.Class.forName("org.eclipse.emf.ecore.EClass");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isInstance(eStructuralFeature.getEType())) {
                    throw new IllegalArgumentException(String.valueOf(propertyName));
                }
                if (EcorePackage.eINSTANCE.getEEnum().isInstance((Object)eStructuralFeature.getEType())) {
                    java.lang.Class<?> clazz2 = class$5;
                    if (clazz2 == null) {
                        try {
                            clazz2 = java.lang.Class.forName("org.eclipse.uml2.EnumerationLiteral");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2.isInstance(value)) {
                        value = ((EEnum)eStructuralFeature.getEType()).getEEnumLiteral(UML2Operations.getValidIdentifier(((EnumerationLiteral)value).getName())).getInstance();
                    }
                }
                if (value == null) {
                    value = eStructuralFeature.getDefaultValue();
                }
                if (eStructuralFeature.isMany()) {
                    if (-1 == index) {
                        throw new IllegalArgumentException(String.valueOf(propertyName));
                    }
                    list = (List)eObject.eGet(eStructuralFeature);
                    j = list.size();
                    while (j < index) {
                        list.add(j, eStructuralFeature.getDefaultValue());
                        ++j;
                    }
                    if (index == list.size()) {
                        list.add(index, value);
                    } else {
                        list.set(index, value);
                    }
                } else {
                    eObject.eSet(eStructuralFeature, value);
                }
                if (StereotypeOperations.getEObject(stereotype, element) == null) {
                    UML2Operations.getOrCreateEAnnotation(ANNOTATION_SOURCE__APPLIED_STEREOTYPES, element).getContents().add((Object)stereotypeEObject);
                }
            }
            ++i;
        }
    }

    public static void unapply(Stereotype stereotype, Element element) {
        if (stereotype == null || StereotypeOperations.isRequired(stereotype, element) || !StereotypeOperations.isApplied(stereotype, element)) {
            throw new IllegalArgumentException(String.valueOf(stereotype));
        }
        EAnnotation appliedStereotypesEAnnotation = UML2Operations.getEAnnotation(ANNOTATION_SOURCE__APPLIED_STEREOTYPES, element);
        Iterator contents = appliedStereotypesEAnnotation.getContents().iterator();
        while (contents.hasNext()) {
            if (stereotype != StereotypeOperations.getStereotype((EObject)contents.next())) continue;
            contents.remove();
        }
        if (appliedStereotypesEAnnotation.getContents().isEmpty()) {
            element.getEAnnotations().remove((Object)appliedStereotypesEAnnotation);
        }
    }

    public static Profile getProfile(Stereotype stereotype) {
        return stereotype == null ? null : (Profile)stereotype.getPackage();
    }

    public static String getKeyword(Stereotype stereotype) {
        String keyword = "";
        if (stereotype != null) {
            try {
                ResourceBundle resourceBundle = ProfileOperations.getResourceBundle(stereotype.getProfile());
                if (resourceBundle != null) {
                    keyword = resourceBundle.getString(stereotype.getQualifiedName().replace(':', '_'));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            if (UML2Operations.isEmpty(keyword)) {
                String identifier = UML2Operations.getValidIdentifier(stereotype.getName());
                keyword = identifier.length() > 0 ? String.valueOf(Character.toLowerCase(identifier.charAt(0))) + identifier.substring(1) : identifier;
            }
        }
        return keyword;
    }
}

