/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EndLoggingAction.java,v 1.1 2004/03/26 15:24:15 marcelop Exp $
 */
package org.eclipse.emf.ecore.sdo.action;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

import commonj.sdo.ChangeSummary;


/**
 * 
 */
public class EndLoggingAction 
  extends ActionDelegate
  implements IActionDelegate
{
  protected ChangeSummary changeSummary;

  public EndLoggingAction()
  {
  }

  public void run(IAction action)
  {
    changeSummary.endLogging();
  }

  public void selectionChanged(IAction action, ISelection selection) 
  {
    if (selection instanceof IStructuredSelection)
    {
      Object object = ((IStructuredSelection)selection).getFirstElement();
      if (object instanceof ChangeSummary)
      {
        changeSummary = (ChangeSummary)object;
        if (changeSummary.isLogging())
        {
          action.setEnabled(true);
          return;
        }
      }
    }
    changeSummary = null;
    action.setEnabled(false);
  }

}
