/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.rose2ecore;

import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.rose2ecore.RoseUtil;
import org.eclipse.emf.codegen.ecore.rose2ecore.UnitTreeNode;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class Rose2Ecore
implements IPlatformRunnable {
    protected RoseUtil roseUtil;
    protected UnitTreeNode unitTree;
    protected ResourceSet resourceSet;

    public static void main(String[] argv) {
        Rose2Ecore rose2Ecore = new Rose2Ecore();
        rose2Ecore.run(argv);
    }

    public Object run(Object object) {
        String[] arguments = (String[])object;
        this.roseUtil = new RoseUtil();
        this.unitTree = null;
        this.resourceSet = null;
        if (arguments.length == 0) {
            System.out.println("Usage: <model-file> { -package <name> <nsName> <nsURI> }+ -pathMap { <variable> <directory> }+");
            return new Integer(0);
        }
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i].equalsIgnoreCase("-package")) {
                String packageName = arguments[++i];
                String nsName = arguments[++i];
                String nsURI = arguments[++i];
                this.roseUtil.packageNameToNSNameMap.put(packageName, nsName);
                this.roseUtil.packageNameToNSURIMap.put(packageName, nsURI);
            } else if (arguments[i].equalsIgnoreCase("-pathMap")) {
                do {
                    String variable = arguments[++i];
                    String directory = arguments[++i];
                    this.roseUtil.variableToDirectoryMap.put(variable, directory);
                } while (i + 1 < arguments.length && !arguments[i + 1].startsWith("-"));
            }
            ++i;
        }
        this.convert(arguments[0]);
        return new Integer(0);
    }

    protected void convert(String fileName) {
        try {
            this.unitTree = this.roseUtil.createRoseUnitTreeAndTable(fileName, null);
            this.roseUtil.createExtent4RoseUnitTree(this.unitTree);
            this.roseUtil.processUnitTree(this.unitTree);
            this.resourceSet = new ResourceSetImpl();
            this.roseUtil.createResource(this.unitTree, this.resourceSet);
            this.roseUtil.saveEcoreFiles(this.resourceSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            CodeGenEcorePlugin.INSTANCE.log(e);
        }
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected UnitTreeNode getUnitTree() {
        return this.unitTree;
    }
}

