/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.WrapperItemProvider;

public class DelegatingWrapperItemProvider
extends WrapperItemProvider
implements IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IEditingDomainItemProvider,
IChangeNotifier,
INotifyChangedListener {
    protected Object delegateItemProvider;
    protected Map childrenMap;
    protected Collection delegateChildren;
    protected List propertyDescriptors;
    protected IChangeNotifier changeNotifier;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DelegatingWrapperItemProvider(Object value, Object owner, AdapterFactory adapterFactory) {
        super(value, owner, adapterFactory);
        if (value == null) {
            throw new IllegalArgumentException("value=null");
        }
        Object delegateValue = this.getDelegateValue();
        if (delegateValue != null) {
            AdapterFactory adapterFactory2 = this.getRootAdapterFactory();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IStructuredItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.delegateItemProvider = adapterFactory2.adapt(delegateValue, (Object)clazz);
            if (this.delegateItemProvider instanceof IChangeNotifier) {
                ((IChangeNotifier)this.delegateItemProvider).addListener(this);
            }
        }
    }

    public void dispose() {
        if (this.delegateItemProvider instanceof IChangeNotifier) {
            ((IChangeNotifier)this.delegateItemProvider).removeListener(this);
        }
        if (this.childrenMap != null) {
            Iterator i = this.childrenMap.values().iterator();
            while (i.hasNext()) {
                ((IDisposable)i.next()).dispose();
            }
        }
    }

    protected Object getDelegateValue() {
        return this.value;
    }

    public Collection getElements(Object object) {
        return this.delegateItemProvider instanceof IStructuredItemContentProvider ? ((IStructuredItemContentProvider)this.delegateItemProvider).getElements(this.getDelegateValue()) : Collections.EMPTY_LIST;
    }

    public Collection getChildren(Object object) {
        this.updateChildren();
        ArrayList result = new ArrayList(this.delegateChildren.size());
        Iterator i = this.delegateChildren.iterator();
        while (i.hasNext()) {
            result.add(this.childrenMap.get(i.next()));
        }
        return result;
    }

    protected void updateChildren() {
        if (this.delegateItemProvider instanceof ITreeItemContentProvider) {
            IWrapperItemProvider wrapper;
            Object child;
            Set oldDelegateChildren = this.delegateChildren != null ? new HashSet(this.delegateChildren) : Collections.EMPTY_SET;
            this.delegateChildren = ((ITreeItemContentProvider)this.delegateItemProvider).getChildren(this.getDelegateValue());
            if (this.childrenMap == null && !this.delegateChildren.isEmpty()) {
                this.childrenMap = new HashMap();
            }
            Iterator i = this.delegateChildren.iterator();
            while (i.hasNext()) {
                child = i.next();
                if (!this.childrenMap.containsKey(child)) {
                    wrapper = this.createWrapper(child, this, this.adapterFactory);
                    this.childrenMap.put(child, wrapper);
                }
                oldDelegateChildren.remove(child);
            }
            i = oldDelegateChildren.iterator();
            while (i.hasNext()) {
                child = i.next();
                wrapper = (IWrapperItemProvider)this.childrenMap.remove(child);
                if (wrapper == null) continue;
                wrapper.dispose();
            }
        } else {
            this.delegateChildren = Collections.EMPTY_LIST;
        }
    }

    protected IWrapperItemProvider createWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
        return new DelegatingWrapperItemProvider(value, owner, adapterFactory);
    }

    public boolean hasChildren(Object object) {
        return this.delegateItemProvider instanceof ITreeItemContentProvider ? ((ITreeItemContentProvider)this.delegateItemProvider).hasChildren(this.getDelegateValue()) : false;
    }

    public String getText(Object object) {
        return this.delegateItemProvider instanceof IItemLabelProvider ? ((IItemLabelProvider)this.delegateItemProvider).getText(this.getDelegateValue()) : null;
    }

    public Object getImage(Object object) {
        return this.delegateItemProvider instanceof IItemLabelProvider ? ((IItemLabelProvider)this.delegateItemProvider).getImage(this.getDelegateValue()) : null;
    }

    public List getPropertyDescriptors(Object object) {
        if (this.propertyDescriptors == null) {
            if (this.delegateItemProvider instanceof IItemPropertySource) {
                List l = ((IItemPropertySource)this.delegateItemProvider).getPropertyDescriptors(this.getDelegateValue());
                this.propertyDescriptors = new ArrayList(l.size());
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    IItemPropertyDescriptor desc = (IItemPropertyDescriptor)i.next();
                    this.propertyDescriptors.add(new ItemPropertyDescriptorDecorator(this.getDelegateValue(), desc));
                }
            } else {
                this.propertyDescriptors = Collections.EMPTY_LIST;
            }
        }
        return this.propertyDescriptors;
    }

    public Object getEditableValue(Object object) {
        return this.delegateItemProvider instanceof IItemPropertySource ? ((IItemPropertySource)this.delegateItemProvider).getEditableValue(this.getDelegateValue()) : null;
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return this.delegateItemProvider instanceof IEditingDomainItemProvider ? ((IEditingDomainItemProvider)this.delegateItemProvider).getNewChildDescriptors(this.getDelegateValue(), editingDomain, sibling) : Collections.EMPTY_LIST;
    }

    public Command createCommand(Object object, EditingDomain domain, Class commandClass, CommandParameter commandParameter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.edit.command.DragAndDropCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (commandClass == clazz) {
            DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getFeature();
            return this.createDragAndDropCommand(domain, commandParameter.getOwner(), detail.location, detail.operations, detail.operation, commandParameter.getCollection());
        }
        if (this.delegateItemProvider instanceof IEditingDomainItemProvider) {
            commandParameter.setOwner(this.getDelegateValue());
            Command result = ((IEditingDomainItemProvider)this.delegateItemProvider).createCommand(this.getDelegateValue(), domain, commandClass, commandParameter);
            return this.wrapCommand(result, commandClass);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command wrapCommand(Command command, Class commandClass) {
        return command instanceof CommandActionDelegate ? new AffectedObjectsWrappingCommandActionDelegate((CommandActionDelegate)command) : new AffectedObjectsWrappingCommand(command);
    }

    public void addListener(INotifyChangedListener listener) {
        if (this.changeNotifier == null) {
            this.changeNotifier = new ChangeNotifier();
        }
        this.changeNotifier.addListener(listener);
    }

    public void removeListener(INotifyChangedListener listener) {
        if (this.changeNotifier != null) {
            this.changeNotifier.removeListener(listener);
        }
    }

    public void fireNotifyChanged(Notification notification) {
        if (this.adapterFactory instanceof IChangeNotifier) {
            IChangeNotifier adapterFactoryChangeNotifier = (IChangeNotifier)this.adapterFactory;
            adapterFactoryChangeNotifier.fireNotifyChanged(notification);
        }
        if (this.changeNotifier != null) {
            this.changeNotifier.fireNotifyChanged(notification);
        }
    }

    public void notifyChanged(Notification notification) {
        if (this.getRefreshElement(notification) == this.getDelegateValue()) {
            this.fireNotifyChanged(this.wrapNotification(notification));
        }
    }

    protected Object getRefreshElement(Notification notification) {
        if (notification instanceof IViewerNotification) {
            return ((IViewerNotification)notification).getElement();
        }
        return notification.getNotifier();
    }

    protected Notification wrapNotification(Notification notification) {
        return ViewerNotification.wrapNotification(notification, this);
    }

    public class AffectedObjectsWrappingCommand
    extends CommandWrapper {
        public AffectedObjectsWrappingCommand(Command command) {
            super(command);
        }

        public Collection getAffectedObjects() {
            ArrayList result = new ArrayList(super.getAffectedObjects());
            DelegatingWrapperItemProvider.this.updateChildren();
            ListIterator<DelegatingWrapperItemProvider> i = result.listIterator();
            while (i.hasNext()) {
                Object wrapper;
                Object object = i.next();
                if (object == DelegatingWrapperItemProvider.this.getDelegateValue()) {
                    i.set(DelegatingWrapperItemProvider.this);
                    continue;
                }
                if (DelegatingWrapperItemProvider.this.childrenMap == null || (wrapper = DelegatingWrapperItemProvider.this.childrenMap.get(object)) == null) continue;
                i.set((DelegatingWrapperItemProvider)wrapper);
            }
            return result;
        }
    }

    public class AffectedObjectsWrappingCommandActionDelegate
    extends AffectedObjectsWrappingCommand
    implements CommandActionDelegate {
        CommandActionDelegate commandActionDelegate;

        public AffectedObjectsWrappingCommandActionDelegate(CommandActionDelegate command) {
            super((Command)command);
            this.commandActionDelegate = command;
        }

        public boolean canExecute() {
            return this.commandActionDelegate.canExecute();
        }

        public Object getImage() {
            return this.commandActionDelegate.getImage();
        }

        public String getText() {
            return this.commandActionDelegate.getText();
        }

        public String getDescription() {
            return this.commandActionDelegate.getDescription();
        }

        public String getToolTipText() {
            return this.commandActionDelegate.getToolTipText();
        }
    }
}

