#
# (C) Tenable Network Security
#
if(description)
{
 script_id(13643);
 script_bugtraq_id(10711);
 script_version("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0215");
 name["english"] = "Cumulative Security Update for Outlook Express (823353)";

 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing a cumulative security update for Outlook Express
which fixes a denial of service vulnerability in the Outlook Express mail
client.

To exploit this vulnerability, an attacker would need to send a malformed
message to a victim on the remote host. The message will crash her version
of Outlook, thus preventing her from reading her e-mail.

Solution : http://www.microsoft.com/technet/security/bulletin/ms04-018.mspx
Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for ms04-018 over the registry";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_hotfixes.nasl");
 script_require_keys("SMB/Registry/Enumerated");
 exit(0);
}

include("smb_nt.inc");
include("smb_hotfixes.inc");
port = get_kb_item("SMB/transport");
if(!port)port = 139;

if ( hotfix_check_sp(nt:7, win2k:5,xp:2, win2003:1) <= 0 ) exit(0);
if ( hotfix_missing(name:"KB823353") <= 0 ) exit(0);

key = "SOFTWARE\Microsoft\Active Setup\Installed Components\{F5173CF0-1DFB-4978-8E50-A90169EE7CA9}";
item = "IsInstalled";
value = registry_get_dword(item:item, key:key);
if ( value ) exit(0);
security_warning(port);
