# This script was written by Jeff Adams <jadams@netcentrics.com>;
#
#
if(description)
{
 script_id(12106);
 script_version("$Revision: 1.43 $");
 name["english"] = "Norton Anti Virus Check";

 script_name(english:name["english"]);
 desc["english"] = "
Checks that the remote host has Norton Antivirus installed and
properly running, and makes sure that the latest Vdefs are loaded.

Solution : Make sure NAV is installed, running and using the latest VDEFS.
Risk factor : High";

 script_description(english:desc["english"]);
 summary["english"] = "Checks that Norton Antivirus installed and then makes sure the latest Vdefs are loaded."; 
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2004 Jeff Adams"); 
 family["english"] = "Windows"; 
 script_family(english:family["english"]);
 script_dependencies("netbios_name_get.nasl", "smb_login.nasl", "smb_registry_full_access.nasl", "smb_enum_services.nasl"); 
 script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/registry_full_access", "SMB/domain","SMB/transport","SMB/svcs");
 script_require_ports(139, 445); 
 exit(0);
}
include("smb_nt.inc");

services = get_kb_item("SMB/svcs");
if ( ! services ) exit(0);

access = get_kb_item("SMB/registry_full_access");
if( ! access )exit(0);
port = kb_smb_transport();
if(!port)port = 139;
key = "SOFTWARE\Symantec\InstalledApps\";
item = "NAVNT";
value = string(registry_get_sz(key:key, item:item));
if ( ! value ) item = "SAVCE";
value = string(registry_get_sz(key:key, item:item));

if( ! value ) exit(0); # Norton Not installed


# We could check if the vdefs are up-to-date
key = "SOFTWARE\Symantec\SharedDefs\"; 
item = "DEFWATCH_10"; 
Vdefs = string(registry_get_sz(key:key, item:item));

if(Vdefs)
{
    ver = substr(Vdefs, 39, 46);
    info = string ("Old Virus Definitions are being used. Please upgrade ASAP!  
           Vdefs Version:
           ",ver);
#
# Modify the date on the line below as newer Vdefs are released. 
#
    virus = "20041208";

    if(int(ver) < int(virus)) 
    {
report = "
Norton AntiVirus is installed on the remote host but the virus
definitions have not been updated in a long time - the newest 
vdefs timestamp is " + virus + ". 

As a result, the remote host may be infectable by newer viruses and
worms.

Solution : Configure the remote AntiVirus to check for updates regularly.
Risk factor : Medium";
    security_warning(port:port, data:report);
   }
}

#
# Checks to see if the service is running (requires null sessons and messenger service).
#
if(services)
{
  report = "
Norton AntiVirus is installed on this host, but is not running.
As a result, the remote host might be infected by viruses received by
email or other means. 

Solution : Enable NAV on the remote host
Risk factor : Medium";
  if("[Norton AntiVirus Server]" >!< services)security_warning(port:port, data:report);
}
