#
# (C) Tenable Network Security
#
#

if(description)
{
  script_id(12025);
  script_bugtraq_id(9445);
  script_version("$Revision: 1.3 $");
  name["english"] = "Mambo Code injection Vulnerability";
  script_name(english:name["english"]);
 
  desc["english"] = "
The remote host is running Mambo, an content management system written in PHP.

There is a flaw in this product which may allow an attacker to execute
arbitrary PHP code on this by forcing this set of CGI to include a
PHP script hosted on a third party host.

Solution : Upgrade to the latest version of this software
Risk factor : High";

  script_description(english:desc["english"]);
 
  summary["english"] = "Detect mambo code injection vuln";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");

  family["english"] = "CGI abuses";
  script_family(english:family["english"]);
  script_dependencie("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if (! get_port_state(port) ) exit(0);
if (! can_host_php(port:port) ) exit(0);


function check_dir(path)
{
 req = http_get(item:string(path, "/modules/mod_mainmenu.php?mosConfig_absolute_path=http://xxxxxxx"), port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if ( res == NULL ) exit(0);

 if ("http://xxxxxxx/modules" >< res ) 
 {
  security_hole(port);
  exit(0);
 }
}

foreach dir (cgi_dirs())
{
check_dir(path:dir);
}

