#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12624);
 script_bugtraq_id(10168);
 script_cve_id("CAN-2004-0409");
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports: xchat2 < 2.0.8_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of xchat2 installed.

xchat2 is an IRC client. There is a stack buffer overflow in the remote version
of this package which may allow an attacker to execute arbitrary code on this
host.

To exploit this flaw, an xchat2 user of the remote host needs to use xchat with
a SOCKS proxy (SOCKS support is disabled by default in the FreeBSD port). An
attacker would then need to impersonate the SOCKS server by a rogue one which
would send oversized packets.

Solution : http://www.vuxml.org/freebsd/8338a20f-9573-11d8-9366-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xchat2 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^xchat2-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"xchat2-2.0.8_2") < 0 ) 
	security_warning(0);
