#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14815);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id(11204);
 name["english"] = "FreeBSD Ports : sudo = 1.6.8";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the sudo package which is equal
to 1.6.8. 

sudo 1.6.8 sports a new feature ('sudoedit') which may allow users to
read the content of arbitrary files with superuser privileges.

Solution : http://www.vuxml.org/freebsd/a268ef4a-0b35-11d9-8a8a-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sudo package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^sudo-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"sudo-1.6.8") == 0 ) 
	security_hole(0);
