#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12611);
 script_bugtraq_id(9637);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0082");
 name["english"] = "FreeBSD Ports : samba < 3.0.1_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of Samba installed.

Samba provides file and printer sharing services to SMB/CIFS clients.
There is a bug in the remote Samba package. When an account for a user
is created but marked as disabled by the mksmbpasswrd script, Samba
may overwrite the user password with the contents of an un-initialized buffer,
which in turn may lead to a disabled account becoming enabled with a password
that can be guessed by an attacker.

Solution : http://www.vuxml.org/freebsd/3388eff9-5d6e-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the samba package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^samba-3\.0", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"samba-3.0.1_2") < 0 ) 
	security_hole(0);
