#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15810);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 11618 );
 script_cve_id ("CAN-2004-0983");
 name["english"] = "FreeBSD Ports : ruby < 1.8.2.p3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

ruby < 1.8.2.p3
ruby_r < 1.8.2.p3
ruby_static < 1.8.2.p3
a2001.05.12 <= ruby-1.7.0 <= a2001.05.2

The Ruby CGI.rb module contains a bug which can cause the  CGI module to go 
into an infinite loop, thereby causing a  denial-of-service situation on the 
web server by using all  available CPU time.

Solution : http://www.vuxml.org/freebsd/d656296b-33ff-11d9-a9e7-0001020eed82.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ruby package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ruby-1\.8", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ruby-1.8.2.p3") < 0  )
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^ruby_r-1\.8", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ruby_r-1.8.2.p3") < 0  )
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^ruby_static-1\.8", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ruby_static-1.8.2.p3") < 0  )
	{
	security_warning(0);
	exit(0);
	}
package = egrep(pattern:"^ruby-1\.7\.0", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ruby-1.7.0-a2001.05.26") <= 0  )
	{
	security_warning(0);
	exit(0);
	}
