#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15808);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 11592 );
 name["english"] = "FreeBSD Ports : proxytunnel < 1.2.3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

proxytunnel < 1.2.3

Florian Schilhabel of the Gentoo Linux Security Audit  project found a format 
string vulnerability in  Proxytunnel. When the program is started in daemon 
mode  (-a [port]), it improperly logs invalid proxy answers to  syslog.

A malicious remote server could send specially-crafted  invalid answers to 
exploit the format string  vulnerability, potentially allowing the execution 
of  arbitrary code on the tunnelling host with the rights of  the Proxytunnel 
process.

See also : http://www.gentoo.org/security/en/glsa/glsa-200411-07.xml
Solution : http://www.vuxml.org/freebsd/50744596-368f-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the proxytunnel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^proxytunnel-[01]", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"proxytunnel-1.2.3") < 0  )
	{
	security_hole(0);
	exit(0);
	}
