#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12605);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0831");
 name["english"] = "FreeBSD Ports : ProFTPD ASCII translation bug";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of ProFTPD installed.

ProFTPD is an alternative FTP server. There is a bug in the remote version
of ProFTPD which may allow an attacker to execute arbitrary commands on the
remote host with the superuser privileges. This overflow exists in the ProFTPD
code which handles the translation of the newlines characters during 
ASCII-mode file uploads. 

To exploit this flaw, an attacker would need to be able to log into the
remote ProFTPD server and would need the ability to upload files.

Solution : http://www.vuxml.org/freebsd/cf0fb426-3f96-11d8-b096-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the proftpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^proftpd", string:pkgs);
if ( ! package ) exit(0);

if ( pkg_cmp(pkg:package, reference:"proftpd-1.2.8_1") < 0 ) 
	security_hole(0);
