#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12603);
 script_bugtraq_id(10168);
 script_cve_id("CAN-2004-0409");
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports: pound < 1.6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of pound installed.

pound is a reverse proxy, load balancer and HTTP front end for web servers.
There is a format string issue in the remote version of this software which
may allow an attacker to execute arbitrary code on this host.

Solution : http://www.vuxml.org/freebsd/fb521119-9bc4-11d8-9366-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pound package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^pound-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"pound-1.6") < 0 ) 
	security_hole(0);
