#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15807);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 11295 );
 script_cve_id ( "CAN-2004-0977" );
 name["english"] = "FreeBSD Ports : postgresql-contrib < 7.2.6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

postgresql-contrib < 7.2.6
7.3.x < postgresql-contrib < 7.3.8
7.4.x < postgresql-contrib < 7.4.6

The make_oidjoins_check script in the PostgreSQL RDBMS has  insecure handling 
of temporary files, which could lead to an attacker overwriting arbitrary 
files with the credentials of  the user running the make_oidjoins_check script.

See also : http://www.postgresql.org/news/234.html
Solution : http://www.vuxml.org/freebsd/6a164d84-2f7f-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the postgres-contrib package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^postgresql-contrib-([0-6]|7\.[0-2])", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"postgresql-contrib-7.2.6") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^postgresql-contrib-7\.3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"postgresql-contrib-7.3.8") < 0  )
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^postgresql-contrib-7\.4", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"postgresql-contrib-7.4.6") < 0  )
	{
	security_hole(0);
	exit(0);
	}
