#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12599);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : pine <= 4.21";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of pine (or iw-pine or zh-pine) installed.

pine is a mail user agent. There are is a buffer overflow in the remote
version of this software which may allow an attacker to execute arbitrary
commands on this host.

To exploit this vulnerability, an attacker would need to send a specially
crafted URL to a victim using pine on this host. When the victim would read
the mail, the overflow would occur.

Solution : http://www.vuxml.org/freebsd/5789a92e-5d7f-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pine package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^pine", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"pine-4.21_1") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^iw-pine", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"iw-pine-4.21_1") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
package = egrep(pattern:"^zh-pine", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"zh-pine-4.21_1") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
