#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12598);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : phpnuke < 7.3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the package phpnuke installed (older than
version 7.5).

The remote version of this software includes several programming mistakes which
may allow an attacker to execute arbitrary SQL queries against the remote database,
exploit cross site scripting issues to steal the cookies of the board users,
or to get access to the administrator account of PHP-Nuke.

Solution : Disable PHP-Nuke. Do not use this software, it's insecure.
See also : http://www.vuxml.org/freebsd/33ab4a47-bfc1-11d8-b00e-000347a4fa7d.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpnuke package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^phpnuke-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"phpnuke-7.3") < 0 ) 
	security_hole(0);
