#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12549);
 script_bugtraq_id(10035);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0371");
 name["english"] = "FreeBSD SA-04:08: heimdal";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of FreeBSD which ships with a version
of heimdal containing a security bug.

heimdal is an implementation of Kerberos V. Heimdal does not correctly 
validate the `transited' field of  Kerberos tickets when computing the 
authentication path. This  could allow a rogue KDC with which cross-realm 
relationships have been established to impersonate any KDC in the 
authentication path.  

Solution : http://www.vuxml.org/freebsd/bfb36941-84fa-11d8-a41f-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the heimdal package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^heimdal-", string:pkgs);
if ( package )
{
if ( pkg_cmp(pkg:package, reference:"heimdal-0.6.1") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
}

package = get_kb_item("Host/FreeBSD/release");
if ( egrep(pattern:"FreeBSD-5\.", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-5.2_6") < 0 )
 {
  security_hole(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.[0-8]([^0-9]|$)", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.8_19") < 0 )
 {
  security_hole(port);
  exit(0);
 }
}

if ( egrep(pattern:"FreeBSD-4\.9", string:package) )
{
 if ( pkg_cmp(pkg:package, reference:"FreeBSD-4.9_6") < 0 )
 {
  security_hole(port);
  exit(0);
 }
}
