#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12533);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : cyrus-imspd < 1.6a5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the cyrus-imspd package which is
older than 1.6a5.

cyrus-ismpd is a IMSP (Internet Message Support Protocol) server. There are
multiple vulnerabilities in the remote version of this software which may allow
an attacker to execute arbitrary code on the remote host using a buffer overflow
in this service.

Solution : http://www.vuxml.org/freebsd/700d43b4-a42a-11d8-9c6d-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the cyrus-imspd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^cyrus-imspd", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"cyrus-imspd-1.6a5") < 0 )
	security_hole(0);
