# This script was written by Jeff Adams <jadams@netcentrics.com>;
#
#
if(description)
{
 script_id(12107);
 script_version("$Revision: 1.41 $");
 name["english"] = "McAfee Anti Virus Check";
 script_name(english:name["english"]);
 desc["english"] = "
This plugin checks that the remote host has the McAfee Antivirus installed 
and then makes sure the latest Vdefs are loaded.

Solution : Make sure Mcafee is installed and using the latest VDEFS.
Risk factor : Medium";

 script_description(english:desc["english"]);
 summary["english"] = "Checks that the remote host has McAfee Antivirus installed and then makes sure the latest Vdefs are loaded."; 
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2004 Jeff Adams"); 
 family["english"] = "Windows"; 
 script_family(english:family["english"]);
 script_dependencies("netbios_name_get.nasl", "smb_login.nasl", "smb_registry_full_access.nasl", "smb_enum_services.nasl"); 
 script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/registry_full_access","SMB/transport","SMB/svcs");
 script_require_ports(139, 445); 
 exit(0);
}
include("smb_nt.inc");

services = get_kb_item("SMB/svcs");
if ( ! services ) exit(0);

access = get_kb_item("SMB/registry_full_access");
if ( ! access ) exit(0);

port = kb_smb_transport();
if(!port)port = 139;

key = "SOFTWARE\Network Associates\TVD\Shared Components\VirusScan Engine\4.0.xx\";
item = "DAT";
value = string(registry_get_sz(key:key, item:item));
if(!value) exit(0);

key = "SOFTWARE\Network Associates\TVD\Shared Components\VirusScan Engine\4.0.xx\"; 
item = "szDatDate"; 
Vdefs = string(registry_get_sz(key:key, item:item));
if(Vdefs)
  {
   date = split(Vdefs, sep:"/", keep:FALSE);
   mustbe = 4 + 2 * 10 + 2004 * 100; # 2/4/2004
   current = int(date[1]) + int(date[0]) * 10 + int(date[2]) * 100;
#
# Modify the date on the line below as newer Vdefs are released. 
#
    info = "
The remote host has an out-dated version (" + Vdefs + ") of the McAfee
virus definitions installed.";
    if(current < mustbe )security_warning(port:port, data:info);
  }



key = "SOFTWARE\Network Associates\TVD\Shared Components\VirusScan Engine\4.0.xx\"; 
item = "szEngineVer"; 
vers = string(registry_get_sz(key:key, item:item));
if(vers)
  {
    mustbe = 4 * 1000 + 3 * 100 + 20; # 4.3.20
    version = split(vers, sep:".", keep:FALSE);
    current = int(version[0]) * 1000 + int(version[1]) * 100 + int(version[2]);
    info = "
The remote host has an out-dated version (" + vers + ") of the McAfee
anti-virus engine.";
    if(current < mustbe )
    {
     key = "SOFTWARE\Network Associates\TVD\VirusScan Enterprise\CurrentVersion\"; 
     item = "szEngineVer"; 
     vers = string(registry_get_sz(key:key, item:item));
     if (!vers) security_warning(port:port, data:info);
     else
     {
      version = split(vers, sep:".", keep:FALSE);
      current = int(version[0]) * 1000 + int(version[1]) * 100 + int(version[2]);
      if(current < mustbe )
        security_warning(port:port, data:info);
     }
    }
  }


#
# Checks to see if the virus database is up to date.
#
key = "SOFTWARE\Network Associates\TVD\VirusScan Enterprise\CurrentVersion\"; 
item = "szVirDefVer"; 
vers = string(registry_get_sz(key:key, item:item));

if (!vers)
{
 key = "SOFTWARE\Network Associates\TVD\Shared Components\VirusScan Engine\4.0.xx\"; 
 item = "szVirDefVer"; 
 vers = string(registry_get_sz(key:key, item:item));
}

info = "
The remote host has an out-dated version (" + vers + ") of the McAfee
virus database.";

if (!vers) security_warning(port:port, data:info);

datvers="4413";
if ( "4.0." >< vers)
{
	version = split(vers, sep:".", keep:FALSE);
	vers = version[2];
}
if (int(vers) < int(datvers)) security_warning(port:port, data:info);




#
# Checks to see if the service is running (requires null sessons and messenger service).
#
if(("[AvSynMgr]" >!< services) && ("[McShield]" >!< services) ) {
	report = "
The remote host has the McAffee antivirus installed, but it
is not running.

As a result, the remote host might be infected by viruses received by
email or other means. 

Solution : Configure the remote AntiVirus to check for updates regularly.
Risk factor : Medium";
	security_warning(port:port, data:report);
	}


