#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15498);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports: zinf < 2.2.5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of zinf installed.

zinf is a GTK-based MP3 player. There is a buffer overflow in the remote
version of this software in the way it handles playlist files. An attacker
may exploit this flaw to execute arbitrary code on the remote host.

Solution : http://www.vuxml.org/freebsd/30cf9485-1c2c-11d9-9ecb-000c6e8f12ef.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the zinf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^zinf-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"zinf-2.2.5") < 0 ) 
	security_hole(0);
