#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12626);
 script_bugtraq_id(9939);
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports: xine < 0.9.23_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of xine installed.

xine is a movie player. The remote version of this software contains a
temporary file problem in its xine-check and xine-bugreport scripts which may
allow a local attacker to overwrite files he should not have access to.

Solution : http://www.vuxml.org/freebsd/fde53204-7ea6-11d8-9645-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xine package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^xine-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"xine-0.9.23_3") < 0 ) 
	security_warning(0);
