#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14760);
 script_version ("$Revision: 1.1 $");
 script_cve_id("CAN-2004-0559");
 name["english"] = "FreeBSD Ports : webmin < 1.150_5";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the webmin package which is older
than webmin-1.150_5

There is a security issue in the script 'maketemp.pl' which is included with
this software which may allow an attacker to overwrite arbitrary files
when the webmin software is being installed.

Solution : http://www.vuxml.org/freebsd/ae7b7f65-05c7-11d9-b45d-000c41e2cdad.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the webmin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^webmin-[0-9]", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"webmin-1.150_5") < 0 ) 
	security_warning(0);
