#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12593);
 script_bugtraq_id(9984);
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports: phpBB <= 2.0.8";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of phpBB installed.

phpBB is a PHP-based bulletin board system. There is a critical SQL injection
issue in the remote version of this software which may allow an attacker to
obtain the username and md5 of the password of the admin user of the remote
installation.

Solution : http://www.vuxml.org/freebsd/70f5b3c6-80f0-11d8-9645-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the phpBB package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^phpbb-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"phpbb-2.0.8_1") < 0 ) 
	security_hole(0);
