#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12545);
 script_bugtraq_id(10604);
 script_version ("$Revision: 1.3 $");
 name["english"] = "FreeBSD Ports: giFT-FastTrack < 0.8.7";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of giFT-FastTrack installed which is older 
than 0.8.7.

This package is a FastTrack plugin for giFT, which itself is a peer-to-peer
client for many networks (OpenFT, Gnutella and FastTrack). The remote
version of this software is vulnerable to a denial of service attack which
may allow a remote attacker to make the remote FastTrack HTTP server 
unavailable.

Solution : http://www.vuxml.org/freebsd/1f738bda-c6ac-11d8-8898-000d6111a684.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the giFT-FastTrack package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^giFT-FastTrack-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"giFT-FastTrack-0.8.7") < 0 ) 
	security_warning(0);
