#
# (C) Tenable Network Security
#
#
if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14267);
 script_bugtraq_id(10865, 10889);
 script_version ("$Revision: 1.5 $");
 script_cve_id("CAN-2004-0500");
 name["english"] = "FreeBSD Ports : Gaim less than 0.81_1";

 script_name(english:name["english"]);

 desc["english"] = "
The remote host is running a version of AIM or ja-gaim less than 0.81_1.

AIM/ja-gaim is an AOL instant Messaging client.

This version of AIM/ja-gaim is vulnerable to a remote overflow in the
MSN component

Solution : http://www.vuxml.org/freebsd/5b8f9a02-ec93-11d8-b913-000c41e2cdad.html

Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gaim package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^aim-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"aim-0.81_1") < 0 )
        security_hole(0);

package = egrep(pattern:"^ja-gaim-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ja-gaim-0.81_1") < 0 )
        security_hole(0);


