#
# Copyright (C) 2004 Tenable Network Security 
#
#

if(description)
{
 script_id(11997);
 script_version("$Revision: 1.3 $");

 name["english"] = "DSSAGENT detection";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using the DSSAGENT program.  
You should ensure that:
- the user intended to install DSSAGENT (it is sometimes silently installed) 
- the use of DSSAGENT matches your corporate mandates and security policies.

To remove this sort of software, you may wish to check out ad-aware or spybot. 

See also : http://www.safersite.com/PestInfo/d/dssagent.asp 

Solution : Uninstall this software
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "DSSAGENT detection";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_registry_full_access.nasl");
 script_require_keys("SMB/registry_full_access");

 script_require_ports(139, 445);
 exit(0);
}


# start the script
if ( ! get_kb_item("SMB/registry_full_access") ) exit(0);

path[0] = "software\broderbund software\dss";
path[1] = "software\broderbund software\dss";


include("smb_nt.inc");

for (i=0; path[i]; i++) {
       val = registry_key_exists(key:path[i]);
       if(val != NULL) {security_hole(kb_smb_transport()); exit(0); } 
}


