<?php
/**
 * $Horde: framework/SyncML/SyncML/Sync.php,v 1.8.4.1 2005/01/03 12:19:14 jan Exp $
 *
 * Copyright 2003-2005 Anthony Mills <amills@pyramid6.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Anthony Mills <amills@pyramid6.com>
 * @version $Revision: 1.8.4.1 $
 * @since   Horde 3.0
 * @package Horde_SyncML
 */
class Horde_SyncML_Sync {

    /**
     * Target, either contacts, notes, events,
     */
    var $_targetLocURI;

    var $_sourceLocURI;

    /**
     * Return if all commands success.
     */
    var $globalSuccess;

    /**
     * This is the content type to use to export data.
     */
    var $preferedContentType;

    function &factory($alert)
    {
        switch ($alert) {
        case ALERT_TWO_WAY:
            include_once 'Horde/SyncML/Sync/TwoWaySync.php';
            return $sync = &new Horde_SyncML_Sync_TwoWaySync();

        case ALERT_SLOW_SYNC:
            include_once 'Horde/SyncML/Sync/SlowSync.php';
            return $sync = &new Horde_SyncML_Sync_SlowSync();

        case ALERT_ONE_WAY_FROM_CLIENT:
            include_once 'Horde/SyncML/Sync/OneWayFromClientSync.php';
            return $sync = &new Horde_SyncML_Sync_OneWayFromClientSync();

        case ALERT_REFRESH_FROM_CLIENT:
            include_once 'Horde/SyncML/Sync/RefreshFromClientSync.php';
            return $sync = &new Horde_SyncML_Sync_RefreshFromClientSync();

        case ALERT_ONE_WAY_FROM_SERVER:
            include_once 'Horde/SyncML/Sync/OneWayFromServerSync.php';
            return $sync = &new Horde_SyncML_Sync_OneWayFromServerSync();

        case ALERT_REFRESH_FROM_SERVER:
            include_once 'Horde/SyncML/Sync/RefreshFromServerSync.php';
            return $sync = &new Horde_SyncML_Sync_RefreshFromServerSync();
        }

        require_once 'PEAR.php';
        return PEAR::raiseError('Alert ' . $alert . ' not found.');
    }

    function nextSyncCommand($currentCmdID, &$syncCommand, &$output)
    {
        $result = $this->runSyncCommand($syncCommand);
        return $syncCommand->output($currentCmdID, $output);
    }

    function startSync($currentCmdID, &$output)
    {
        return $currentCmdID;
    }

    function endSync($currentCmdID, &$output)
    {
        return $currentCmdID;
    }

    /**
     * Here's where the actual processing of a client-sent Sync
     * Command takes place. Entries are added, deleted or replaced
     * from the server database by using Horde API (Registry) calls.
     */
    function runSyncCommand($command)
    {
        global $registry;

        require_once 'Horde/History.php';
        $history = &Horde_History::singleton();

        $state = &$_SESSION['SyncML.state'];
        $hordeType = $type = $this->_targetLocURI;
        $contentType = $state->getPreferedContentType($type);
        if ($this->_targetLocURI == 'calendar' && strpos($command->getContent(), 'BEGIN:VTODO') !== false) {
            $hordeType = 'tasks';
        }

        $guid = false;
        if (is_a($command, 'Horde_SyncML_Command_Sync_Add')) {
            $guid = $registry->call($hordeType . '/import',
                                    array($state->convertClient2Server($command->getContent(), $contentType), $contentType));
            if (!is_a($guid, 'PEAR_Error')) {
                $ts = $history->getTSforAction($guid, 'add');
                if(!$ts) {
                    Horde::logMessage('SyncML: unable to find add-ts for ' . $guid . ' at ' . $ts, __FILE__, __LINE__, PEAR_LOG_ERROR);
                }
                $state->setUID($type, $command->getLocURI(), $guid, $ts);
                $state->log("Client-Add");
                Horde::logMessage('SyncML: added client entry as ' . $guid . ' at ' . $ts, __FILE__, __LINE__, PEAR_LOG_DEBUG);
            } else {
                $state->log("Client-AddFailure");
                Horde::logMessage('SyncML: Error in adding client entry:' . $guid->message, __FILE__, __LINE__, PEAR_LOG_ERR);
            }
        } elseif (is_a($command, 'Horde_SyncML_Command_Sync_Delete')) {
            // We can't remove the mapping entry as we need to keep
            // the timestamp information.
            // $guid = $state->removeUID($type, $command->getLocURI());
            $guid = $state->getGlobalUID($type, $command->getLocURI());

            if (!is_a($guid, 'PEAR_Error')) {
                $registry->call($hordeType . '/delete', array($guid));
                $ts = $history->getTSforAction($guid, 'delete');
                $state->setUID($type, $command->getLocURI(), $guid, $ts);
                $state->log("Client-Delete");
                Horde::logMessage('SyncML: deleted entry ' . $guid . ' due to client request', __FILE__, __LINE__, PEAR_LOG_DEBUG);
            } else {
                $state->log("Client-DeleteFailure");
                Horde::logMessage('SyncML: Failure deleting client entry, maybe gone already on server. msg:'. $guid->message, __FILE__, __LINE__, PEAR_LOG_ERR);
            }
        } elseif (is_a($command, 'Horde_SyncML_Command_Sync_Replace')) {
            $guid = $state->getGlobalUID($type, $command->getLocURI());
            $ok = false;
            if ($guid) {
                // Entry exists: replace current one.
                $ok = $registry->call($hordeType . '/replace',
                                      array($guid, $state->convertClient2Server($command->getContent(), $contentType), $contentType));
                if (!is_a($ok, 'PEAR_Error')) {
                    $ts = $history->getTSforAction($guid, 'modify');
                    $state->setUID($type, $command->getLocURI(), $guid, $ts);
                    Horde::logMessage('SyncML: replaced entry ' . $guid . ' due to client request', __FILE__, __LINE__, PEAR_LOG_DEBUG);
                    $state->log("Client-Replace");
                    $ok = true;
                } else {
                    // Entry may have been deleted; try adding it.
                    $ok = false;
                }
            }

            if (!$ok) {
                // Entry does not exist in map or database: add a new
                // one.
                $guid = $registry->call($hordeType . '/import',
                                        array($state->convertClient2Server($command->getContent(), $contentType), $contentType));
                if (!is_a($guid, 'PEAR_Error')) {
                    $ts = $history->getTSforAction($guid, 'add');
                    $state->setUID($type, $command->getLocURI(), $guid, $ts);
                    $state->log("Client-AddReplace");
                    Horde::logMessage('SyncML: r/ added client entry as ' . $guid, __FILE__, __LINE__, PEAR_LOG_DEBUG);
                } else {
                    Horde::logMessage('SyncML: Error in replacing/add client entry:' . $guid->message, __FILE__, __LINE__, PEAR_LOG_ERR);
                    $state->log("Client-AddFailure");
                }
            }
        }

        return $guid;
    }

}
