/*
    ettercap -- L0pht crack converter form ettercap log to LC 4.0

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    $Id: lc-converter.c,v 1.1 2003/01/13 10:14:11 alor Exp $
*/

/*
 * TO COMPILE:
 *
 * gcc lc-converter.c -o lc-converter
 *
 */


#include <stdio.h>

void usage()
{
    printf("usage: lc-converter <input_file> <output_file>\n");
    exit(0);
}

int main(int argc, char **argv)
{
   FILE *fileI, *fileO;
   
   char user[50];
   char challenge[20];
   char hash[100];
   char line[200];

   if(argc!=3) usage();
   
   if ( !(fileI=fopen(argv[1], "r")) ) 
   {
      printf("Can't open input file\n");
      exit(0);
   } 
  
   if ( !(fileO=fopen(argv[2], "w")) )
   {
      printf("Can't open output file\n");
      exit(0);
   }

   while (!feof(fileI))
   {
      fgets(line, 150, fileI);
      if (sscanf(line, "USER: %49s\n", user)==1)
      {
         fgets(line, 150, fileI);
         fgets(line, 150, fileI);
         fgets(line, 150, fileI);
  
         if (sscanf(line, "LC 2.5 FORMAT: \"USER\":3:%16s:%97s\n", challenge,hash)==2)
            fprintf(fileO, "%s:\"\":\"\":%s:%s\n", user, hash, challenge);
      }
   }    
   
   fclose(fileI);
   fclose(fileO);
   
   printf("Done!\n");
   
   return 0;    
}
