# Author: Marcelo Huerta San Martin
# Contact: richieadler@users.sourceforge.net
# Revision: $Revision: 1.1.2.5 $
# Date: $Date: 2005/01/07 13:26:02 $
# Copyright: This module has been placed in the public domain.

# New language mappings are welcome.  Before doing a new translation, please
# read <http://docutils.sf.net/docs/howto/i18n.html>.  Two files must be
# translated for each language: one in docutils/languages, the other in
# docutils/parsers/rst/languages.

"""
Esperanto-language mappings for language-dependent features of Docutils.
"""

__docformat__ = 'reStructuredText'

labels = {
      # fixed: language-dependent
      'author': u'A\u016dtoro',
      'authors': u'A\u016dtoroj',
      'organization': u'Organizo',
      'address': u'Adreso',
      'contact': u'Kontakto',
      'version': u'Versio',
      'revision': u'Revido',
      'status': u'Stato',
      'date': u'Dato',
      # 'copyright': u'Kopirajto',
      'copyright': u'A\u016dtorrajto',
      'dedication': u'Dedi\u0109o',
      'abstract': u'Resumo',
      'attention': u'Atentu!',
      'caution': u'Zorgu!',
      'danger': u'DAN\u011cERO!',
      'error': u'Eraro',
      'hint': u'Spuro',
      'important': u'Grava',
      'note': u'Noto',
      'tip': u'Helpeto',
      'warning': u'Averto',
      'contents': u'Enhavo'}
"""Mapping of node class name to label text."""

bibliographic_fields = {
      # language-dependent: fixed
      'a\u016dtoro': 'author',
      'a\u016dtoroj': 'authors',
      'organizo': 'organization',
      'adreso': 'address',
      'kontakto': 'contact',
      'versio': 'version',
      'revido': 'revision',
      'stato': 'status',
      'dato': 'date',
      'a\u016dtorrajto': 'copyright',
      'dedi\u0109o': 'dedication',
      'resumo': 'abstract'}
"""Esperanto (lowcased) to canonical name mapping for bibliographic fields."""

author_separators = [';', ',']
"""List of separator strings for the 'Authors' bibliographic field. Tried in
order."""
