/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/04/24 16:51:08 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pgtheme.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.1 $
    Status:           $State: Exp $
*/

#ifndef THEME_H
#define THEME_H

#ifdef SWIG
%module theme
%{
#include "theme.h"
%}
#endif

#include "paragui.h"

#define THEME_SUFFIX ".theme"

class DECLSPEC PG_Theme {
public:
	virtual TTF_Font* FindDefaultFont() = 0;
	virtual TTF_Font* FindFont(const char* fontname) = 0;
	virtual TTF_Font* FindFont(const char* widgettype, const char* objectname) = 0;
	virtual SDL_Surface* FindSurface(const char* widgettype, const char* object, const char* name) = 0;
	virtual PG_Gradient* FindGradient(const char* widgettype, const char* object, const char* name) = 0;
	virtual long FindProperty(const char* widgettype, const char* object, const char* name) = 0;
	virtual SDL_Color* FindColor(const char* widgettype, const char* object, const char* name) = 0;
	virtual const char* FindString(const char* widgettype, const char* object, const char* name) = 0;
};

PG_Theme* PARAGUI_LoadTheme(const char* path, const char* xmltheme);
void PARAGUI_UnloadTheme(PG_Theme* theme);

#endif // THEME_H
