/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Alexander Pipelka
    pipelka@teleweb.at

    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/06/13 14:23:51 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pgmessagebox.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.5 $
    Status:           $State: Exp $
*/

#ifndef PG_MESSAGEBOX_H
#define PG_MESSAGEBOX_H

#ifdef SWIG
%include "swigcommon.h"
%module pgmessagebox
%{
#include "pgmessagebox.h"
%}
#endif

#include "pgbutton.h"
#include "pgwindow.h"
#include "pgwidget.h"
#include "paragui.h"

/**
	@author Thomas Bamesberger
*/

class DECLSPEC PG_MessageBox : public PG_Window {
public:
	/**
	Creates a PopUp with 2 Buttons
		
	@param parent							Parent widget
	@param r									rectangle of PopUp
	@param windowtitle					Title of window
	@param windowtext					Text to appear in window
	@param btn1								Struct PG_Rect to create Button 1
	@param btn1text						Text to appear in Button 1
	@param btn2								Struct PG_Rect to create Button 2
	@param btn2text						Text to appear in Button 2
	@param textalign						Alignment for windowtext
	*/
	PG_MessageBox(PG_Widget* parent, const PG_Rect& r, char* windowtitle, char* windowtext, const PG_Rect& btn1, char* btn1text, const PG_Rect& btn2, char* btn2text, int textalign=PG_TA_CENTER, const char* style="MessageBox");

	/**
	Creates a PopUp with 1 Button
		
	@param parent							Parent widget
	@param r									rectangle of PopUp
	@param windowtitle					Title of window
	@param windowtext					Text to appear in window
	@param btn1								Struct PG_Rect to create Button 1
	@param btn1text						Text to appear in Button 1
	@param textalign						Alignment for windowtext
	*/
	PG_MessageBox(PG_Widget* parent, const PG_Rect& r, char* windowtitle, char* windowtext, const PG_Rect& btn1, char* btn1text, int textalign=PG_TA_CENTER, const char* style="MessageBox");

	/**
	Destructor
	*/
	~PG_MessageBox();
		
	void LoadThemeStyle(const char* widgettype);

	/**
	Waits for a button click and returns Button ID
	*/
	int WaitForClick();

protected:

	/**
	Checks Event, if button is clicked, sets buttonflag to ID of Button		

	@param id											ButtonID
	@param widget									widget for Evenet
	*/
	bool eventButtonClick(int id, PG_Widget* widget);

	/**
	Draws the PopUp

	@param surface								Surface
	@param rect										Rectangle of PopUp
	*/
	void eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst);

	/**
	Buttonflag is set to ButtonID, if a button is clicked
	*/
	int buttonflag;

	PG_Button* my_btnok;
	PG_Button* my_btncancel;

private:

	void Init(char* windowtitle, char* windowtext, int textalign, const char* style) ;

	char my_msgtext[512];
	char my_windowtitle[256];
	int my_msgalign;
};

#endif //PG_MESSAGEBOX_H
