/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/04/24 16:51:08 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pgbutton.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.1 $
    Status:           $State: Exp $
*/

#ifndef PG_BUTTON_H
#define PG_BUTTON_H

#ifdef SWIG
%include "swigcommon.h"
%module pgbutton
%{
#include "pgbutton.h"
%}
#endif

#include "pgwidget.h"
#include <string>

/**
	@author Alexander Pipelka

	@short Button with hardcoded colors and gradients, with text or icon.

	This should be integrated with PG_Button once the themeing takes place
	as this current buttom system is a little odd.
*/

class DECLSPEC PG_UserButton : public PG_Widget {
public:

	PG_UserButton(PG_Widget* parent, int btnid, const PG_Rect& r, char* text = NULL);
	virtual ~PG_UserButton();

	/**  */
	void SetBorderColorColor(int b, Uint32 color);
	
	/**  */
	//void DrawBorder(int size=2);
	
	/**  */
#ifndef SWIG
	/** SWIG has problems with this, for some reason..  (?) */
	bool SetIcon(char* filenameup, char* filenamedown = NULL, Uint32 colorkey = 0x000000FF);
#endif
	
	/**  */
#ifdef SWIG
	/** SWIG can't handle multiple functions with one name */
	%name(SetIcon2) bool SetIcon(SDL_Surface* icon_up, SDL_Surface* icon_down = NULL);
#else
	bool SetIcon(SDL_Surface* icon_up, SDL_Surface* icon_down = NULL);
#endif
	
	/**  */
	void SetBorderSize(int norm, int pressed, int high);
	
	/**  */
	void SetToggle(bool bToggle);
	
	/**  */
	void SetPressed(bool pressed);
	
	/**  */
	void SetTransparency(int norm, int pressed, int high);
	
	/**  */
	void SetText(char* text);

	/**  */
	const char* GetText();
	
	/**  */
	bool GetPressed();

protected:

	/**  */
	void eventBlit(SDL_Surface* srf, const PG_Rect& src, const PG_Rect& dst);

	/**  */
	void eventSizeWindow(int w, int h);

	/**  */
	void eventMouseLeave();

	/**  */
	void eventMouseEnter();

	/**  */
	bool eventMouseButtonUp(const SDL_MouseButtonEvent* button);

	/**  */
	bool eventMouseButtonDown(const SDL_MouseButtonEvent* button);

	/**  */
	virtual void OnButtonSurface(SDL_Surface** surface, int newstate, int w, int h);

	int my_bordersize[3];
	int my_transparency[3];
	int my_state;
	int id;
	int my_pressShift;

private:
	PG_UserButton(const PG_UserButton&);
	PG_UserButton& operator=(const PG_UserButton&);
	
	/**  */
	void FreeSurfaces();

	/**  */
	void FreeIcons();

	SDL_Surface* srf_normal;
	SDL_Surface* srf_high;
	SDL_Surface* srf_down;
	SDL_Surface* srf_icon[2];

#ifndef SWIG
	std::string labeltext;
#endif

	bool free_icons;
	
	bool isPressed;
	bool togglemode;
};

/**
	@author Alexander Pipelka

	@short Button that uses themes, all else derived from PG_UserButton

	\anchor theme_PG_Button

	<h2>Theme support</h2><p>

	<b>widget type:</b>		Button (default)<br>
	<b>object name:</b>		Button<br>

	<h3>Parent theme:</h3>

	\ref theme_PG_Widget "PG_Widget" theme<br>

	<h3>Theme sample:</h3>

	\code
	<widget>
		<type value="Button"/>
		<object>
			<name value="Button"/>
			<filename name="background0" value="default/button_unpressed.png"/>
			<filename name="background1" value="default/button_pressed.png"/>
			<filename name="background2" value="default/button_highlighted.png"/>
			<color name="textcolor" value="0x00ff9807"/>
			<property name="backmode0" value="TILE"/>
			<property name="backmode1" value="TILE"/>
			<property name="backmode2" value="TILE"/>
			<gradient name="gradient0" color0="0x000000FF" color1="0x000000FF" color2="0x000000FF" color3="0x000000FF"/>
			<gradient name="gradient1" color0="0x000000FF" color1="0x000000FF" color2="0x000000FF" color3="0x000000FF"/>
			<gradient name="gradient2" color0="0x000000FF" color1="0x000000FF" color2="0x000000FF" color3="0x000000FF"/>
			<property name="blend0" value="0"/>
			<property name="blend1" value="0"/>
			<property name="blend2" value="0"/>
			<property name="bordersize0" value="0"/>
			<property name="bordersize1" value="0"/>
			<property name="bordersize2" value="0"/>
			<property name="transparency0" value="0"/>
			<property name="transparency1" value="0"/>
			<property name="transparency2" value="0"/>
			<filename name="iconup" value="none"/>
			<filename name="icondown" value="none"/>
		</object>
	</widget>
	\endcode
	<p>
	<h2>Code:</h2><p>
*/

class DECLSPEC PG_Button : public PG_UserButton  {
public:

	/**  */
	PG_Button(PG_Widget* parent, int id, const PG_Rect& r, char* text = NULL, const char* style="Button");

	/**  */
	virtual ~PG_Button();

	/**  */
	void LoadThemeStyle(const char* widgettype);

	/**  */
	void LoadThemeStyle(const char* widgettype, const char* objectname);

	/**  */
	void SetGradient(int state, PG_Gradient& gradient);

	/**  */
	void SetBackground(int state, SDL_Surface* background, int mode = BKMODE_TILE);
	
protected:

	/**  */
	void OnButtonSurface(SDL_Surface** surface, int newstate, int w, int h);

private:
	PG_Button(const PG_Button&);
	PG_Button& operator=(const PG_Button&);

	PG_Gradient my_gradState[3];
	SDL_Surface* my_background[3];
	int my_backMode[3];
	int my_backBlend[3];
};

#endif // PG_BUTTON_H
