#
# This script was written by George A. Theall, <theall@tifaware.com>.
#
# See the Nessus Scripts License for details.
#
 
if (description) {
  script_id(12253);
  script_bugtraq_id(10412);
  script_version("$Revision: 1.5 $");

  script_cve_id("CAN-2004-0412");
  if (defined_func("script_xref")) {
    script_xref(name:"CLSA", value:"CLSA-2004:842");
    script_xref(name:"FLSA", value:"FEDORA-2004-1734");
    script_xref(name:"GLSA", value:"GLSA-200406-04");
    script_xref(name:"MDKSA", value:"MDKSA-2004:051");
  }
 
  name["english"] = "Mailman password retrieval";
  script_name(english:name["english"]);
 
  desc["english"] = "
The target is running version of the Mailman mailing list software that
allows a list subscriber to retrieve the mailman password of any other
subscriber by means of a specially crafted mail message to the server. 
That is, a message sent to $listname-request@target containing the
lines :

    password address=$victim
    password address=$subscriber

will return the password of both $victim and $subscriber for the list
$listname. 

Note : Nessus has determined the vulnerability exists only by looking at
the version number of Mailman installed on the target.

Solution : Upgrade to Mailman version 2.1.5 or newer.
Risk factor : Medium";
  script_description(english:desc["english"]);

  summary["english"] = "Checks for Mailman Password Retrieval Vulnerability";
  script_summary(english:summary["english"]);

  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 George A. Theall");

  family["english"] = "Misc.";
  script_family(english:family["english"]);

  script_dependencie("global_settings.nasl", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");

host = get_host_name();
port = get_http_port(default:80);
if (debug_level) display("debug: checking for Mailman Password Retrieval vulnerability on ", host, ":", port, ".\n");

if (!get_port_state(port)) exit(0);

# Search for Mailman's listinfo page.
dirs = make_list("/mailman", cgi_dirs());
foreach dir (dirs) {
    listinfo = string(dir, "/listinfo");
    if (debug_level) display("debug: testing '", listinfo, "'.\n");
    req = http_get(item:listinfo, port:port);
    res = http_keepalive_send_recv(port:port, data:req);
    if (res == NULL) exit(0);           # no web server.
    if (debug_level) display("debug: result = >>", res, "<<\n");

    # Find the version number. It will be in a line such as
    #   <td><img src="/icons/mailman.jpg" alt="Delivered by Mailman" border=0><br>version 2.1.5</td>
    pats = eregmatch(pattern:"alt=.Delivered by Mailman..+>version ([^<]+)", string:res);
    if (pats == NULL) exit(0);
    ver = pats[1];
    if (debug_level) display("debug: version = >>", ver, "<<\n");
    # nb: vulnerability affects versions 2.1 beta 2 - 2.1.4.
    if (ereg(pattern:"^2\.1(b[2-6]|rc1|\.[1-4])", string:ver)) {
        security_warning(port);
        # nb: no sense testing any further.
        exit(0);
    }
}
