#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: gollum <gollum@evilemail.com>
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15400);
 script_bugtraq_id(2933);
 script_cve_id("CAN-2001-1083");
 if (defined_func("script_xref")) script_xref(name:"OSVDB", value:"5472");
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "ICECast crafted URL DoS";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote server runs a version of ICECast, an open source 
streaming audio server, which is older than version 1.3.11.

This version is affected by a remote denial of service because
Icecast server does not properly sanitize user-supplied input.

An remote attacker could send specially crafted URL, by adding '/', '\' or '.' to the end,
that may result in a loss of availability for the service.

*** Nessus reports this vulnerability using only
*** information that was gathered.

Solution : Upgrade to a newer version.
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check icecast version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak",
		francais:"Ce script est Copyright (C) 2004 David Maciejak");
		
 family["english"] = "Misc.";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 8000);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_kb_item("Services/www");
if(!port) port = 8000;

if(get_port_state(port))
{
#for now we just test the banner
soc = open_sock_tcp(port);
if(soc)
{
  req = http_head(item:"/", port:port);
  send(socket:soc,data:req);
  r = http_recv(socket:soc);
  close(soc);
  str = strstr(r, "icecast");
  if(str)
  {
    if(ereg(pattern:"icecast/1\.(1\.|3\.([0-9]|10)[^0-9])", string:str))
      security_hole(port);
  }
 }
}
