#
# (C) Tenable Network Security
#
# osvdb value submitted by David Maciejak
if (description) {
  script_id(14237);
  script_bugtraq_id(10853);
  if ( defined_func("script_xref") ) script_xref(name:"OSVDB", value:"8935");
  script_version ("$Revision: 1.3 $");

  name["english"] = "Goscript command execution";
  script_name(english:name["english"]);
 
  desc["english"] = "
The remote host is running a version of Pete Stein's Goscript
which is vulnerable to a remote command execution flaw.

An attacker, exploiting this flaw, would only need access to 
the webserver.
 
Solution : Upgrade to latest version of Goscript 

See also : http://www.securityfocus.com/bid/10853 
 
Risk factor : High";

  script_description(english:desc["english"]);
 
  summary["english"] = "Goscript command execution detection";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) Tenable Network Security");
  family["english"] = "CGI abuses";
  script_family(english:family["english"]);

  script_require_ports("Services/www", 80);

  exit(0);
}

include("http_func.inc");

port = get_http_port(default:80);

if (!get_port_state(port)) 
	exit(0);


foreach dir (make_list(cgi_dirs()))
{
	req = http_get(item:string(dir, "/go.cgi|id|"), port:port);
	soc = http_open_socket(port);
	if (! soc)
        	exit(0);
	send(socket:soc, data:req);
	r = http_recv(socket:soc);
	http_close_socket(soc);
	if ("uid=" >< r)
		security_hole(port);
}


