#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12627);
 script_bugtraq_id(9718);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0110");
 name["english"] = "FreeBSD Ports : libxml2 < 2.6.6";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the libxml2 package installed.

libxml2 is a library for manipulating XML files. There is a flaw in
this software which may allow an attacker to execute arbitrary code
on this host.

To exploit this flaw, an attacker would need to set up a rogue website
and get a user using a libxml2 enabled application to visit it.


Solution : http://www.vuxml.org/freebsd/847ade05-6717-11d8-b321-000a95bc6fae.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of several packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^libxml2-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"libxml2-2.6.6") < 0 ) 
	security_hole(0);
