#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15815);
 script_version ("$Revision: 1.1 $");
 script_bugtraq_id ( 11674 );
 script_cve_id ( "CAN-2004-1037");
 name["english"] = "FreeBSD Ports : twiki < 20040902";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

twiki < 20040902

The TWiki search function uses a user supplied search  string to compose a 
command line executed by the Perl backtick (``) operator.

The search string is not checked properly for shell  metacharacters and is 
thus vulnerable to search string containing quotes and shell commands.

An attacker is able to execute arbitrary shell  commands with the privileges 
of the TWiki process.

See also : http://marc.theaimsgroup.com/?l=bugtraq&m=110037207516456
Solution : http://www.vuxml.org/freebsd/b4af3ede-36e9-11d9-a9e7-0001020eed82.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the twiki package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^twiki-200", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"twiki-20040902") < 0  )
	{
	security_hole(0);
	exit(0);
	}
