#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12609);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0962");
 name["english"] = "FreeBSD Ports : rsync < 2.5.7";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of rsync installed.

rsync, a program for synchronizing files over the network, is vulnerable
to a heap overflow which may allow an attacker to gain a shell on this
host, provided that rsync server is running on this host.

Solution : http://www.vuxml.org/freebsd/5729b8ed-5d75-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the rsync package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^rsync", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"rsync-2.5.7") < 0 ) 
	security_hole(0);
