#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12608);
 script_bugtraq_id(10072, 10296);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2004-0155", "CAN-2004-0392");
 name["english"] = "FreeBSD Ports: racoon < 20040407b";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of racoon installed.

racoon is an IPSec IKE daemon. There is a flaw in the remote version of racoon
during Phase 1 main or aggressive mode, where it does not verify the client RSA
signature.

In addition to this, there is a denial of service vulnerability in this
package which may allow an attacker to disable racoon remotely.

Solution : http://www.vuxml.org/freebsd/d8769838-8814-11d8-90d1-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the racoon package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^racoon-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"racoon-20040407b") < 0 ) 
	security_hole(0);
