#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12586);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0398");
 name["english"] = "FreeBSD Ports : neon < 0.24.5_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the neon package which is older than 0.24.5_1

The neon library is a WebDAV related client-side library. There is a
bug in the remote version of this software, in the way it parses dates, 
which may allow an attacker to execute arbitrary code on this host. 

To exploit this vulnerability, an attacker would need to create a 
malicious WebDAV server and lure a user of the remote host into 
connecting to it using a neon-enabled client.

Solution : http://www.vuxml.org/freebsd/8d075001-a9ce-11d8-9c6d-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the neon package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^neon-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"neon-0.24.5_1") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
