#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12557);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0988");
 name["english"] = "FreeBSD Ports : kdepim < 3.1.4_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the kdepim package which is
older than 3.1.4_1.

kdepim, a personal information management suite for the KDE graphical
desktop, contains a buffer overflow in the file information reader for
.vcf files, which may allow an attacker to execute arbitrary commands
on the remote host.

To exploit this flaw, an attacker would need to send a malformed .vcf
file to a user of the remote host and wait for him to process it using
kdepim.


Solution : http://www.vuxml.org/freebsd/da6f265b-8f3d-11d8-8b29-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kdepim package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^kdepim-", string:pkgs);
if ( package )
{
if ( pkg_cmp(pkg:package, reference:"kdepim-3.1.0") >= 0 &&
     pkg_cmp(pkg:package, reference:"kdepim-3.1.4_1") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
}
