#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15519);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : imwheel < 1.0.0.p12";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has the following package installed :
	imwheel < 1.0.0.p12

imwheel is a utility to translate mouse wheel actions into X11 keyboard events.

The remote version of this software is vulnerable to a flaw in the way it
handles its PID file, which may allow a local user to cause a denial of
service against the remote host.

Solution : http://www.vuxml.org/freebsd/e31d44a2-21e3-11d9-9289-000c41e2cdad.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the imwheel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^imwheel-[01]", string:pkgs);
if (package && pkg_cmp(pkg:package, reference:"imwheel-1.0.0.p12") < 0 )
	security_warning(0);
