#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12547);
 script_bugtraq_id(9115);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0971");
 name["english"] = "FreeBSD Ports : gnupg < 1.2.3_4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the gnupg package which is older
than 1.2.3_4.

gnupg, a utility for encrypting data and creating digital signatures,
contain a severe bug in the way it generates and uses ElGamal keys when
they are used to both sign and encrypt data. An attacker may use this
flaw to recover the private key of the user.

Solution : http://www.vuxml.org/freebsd/81313647-2d03-11d8-9355-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnupg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^gnupg", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"gnupg-1.2.3_4") < 0 ) 
	security_hole(0);
