#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12539);
 script_bugtraq_id(8071);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0510");
 name["english"] = "FreeBSD Ports: ezbounce < 1.04.a_1";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the ezbounce package which is
older than 1.04.a_1.

ezbounce is an IRC proxy. There is a format string bug in the remote 
version of this software which may allow an attacker to execute 
arbitrary code on this host.

Solution : http://www.vuxml.org/freebsd/c480eb5e-7f00-11d8-868e-000347dd607f.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ezbounce package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ezbounce-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"ezbounce-1.04.a_1") < 0 ) 
	security_hole(0);
