#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15800);
 script_version ("$Revision: 1.1 $");
 script_cve_id ("CAN-2004-0980");
 script_bugtraq_id ( 11657 );
 name["english"] = "FreeBSD Ports : ez-ipupdate < 3.0.11b8_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

ez-ipupdate < 3.0.11b8_2

Data supplied by a remote server is used as the format string  instead of as 
parameters in a syslog() call. This may lead  to crashes or potential running 
of arbitrary code. It is  only a problem when running in daemon mode (very 
common) and  when using some service types.

Solution : http://www.vuxml.org/freebsd/e69ba632-326f-11d9-b5b7-000854d03344.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ez-ipupdate package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^ez-ipupdate-[0-3]\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"ez-ipupdate-3.0.11b8_2") < 0  )
	{
	security_hole(0);
	exit(0);
	}
