#
# (C) Tenable Network Security
#
# The plugin description is (C) Jacques Vidrine and contributors. 
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15796);
 script_version ("$Revision: 1.1 $");
 script_cve_id ("CAN-2004-0942");
 name["english"] = "FreeBSD Ports : apache2 < 2.0.52_2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has one of the following packages installed :

2.x < apache <= 2.0.52_2

It is possible for remote attackers to cause a denial-of-service  scenario on 
Apache 2.0.52 and earlier by sending an HTTP GET request with a MIME header 
containing multiple lines full of  whitespaces.

Solution : http://www.vuxml.org/freebsd/282dfea0-3378-11d9-b404-000c6e8f12ef.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^apache-2\.", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"apache-2.0.52_2") <= 0  )
	{
	security_hole(0);
	exit(0);
	}
