#
# Copyright (C) 2004 Tenable Network Security
#
if(description)
{
 script_id(14270);
 script_bugtraq_id(10915);
 script_version("$Revision: 1.1 $");
 #script_cve_id("");

 name["english"] = "ISS BlackICE Vulnerable config files";

 script_name(english:name["english"]);


 desc["english"] = "
ISS BlackICE is a personal Firewall/IDS for windows Desktops.
Based on the version number, the remote Blackice install is
vulnerable to a local attack due to incorrect file permissions.

*** Nessus based the results of this test on the contents of
*** the local Blackice configuration file.  

Solution : Upgrade to the newest version of BlackICE

Risk factor : High";



 script_description(english:desc["english"]);

 summary["english"] = "ISS BlackICE Vulnerable config file detection";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);

 script_dependencies("netbios_name_get.nasl",
                     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
                     "SMB/WindowsVersion",
                     "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");
include("smb_file_funcs.inc");


mykey = "SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\blackd.exe";
myitem = "Default";
myfile = registry_get_sz(key:mykey, item:myitem);
if (!myfile) 
	exit(0);
myfile = str_replace(find:".exe", replace:".log", string:myfile);
 
myread = smb_file_read(file:myfile, count:2048, offset:0);
if (egrep(string:myread, pattern:"^ERROR")) 
	exit(0);

myread = str_replace(find:raw_string(0), replace:"", string:myread);

if (strstr(myread, "BlackICE Product Version"))  
{
    	if (egrep(string:myread, pattern:"BlackICE Product Version.*3\.(5\.cdf|6\.c(b[drz]|c[a-h]|df))")) 
	{
		security_hole(port);
		exit(0);
	}
}

