#
# Copyright (C) 2004 Tenable Network Security
#

if(description)
{
 script_id(12091);
 script_bugtraq_id(9828);
 #script_cve_id();

 script_version("$Revision: 1.2 $");

 name["english"] = "MSN Messenger Information Disclosure";

 script_name(english:name["english"]);

 desc["english"] = "
The remote host is running MSN Messenger.

The remote host appears to be vulnerable to a remote
attack wherein an attacker can read any local file that
the victim has 'read' access to.

 Solution : Install the patch from Microsoft
 
 Follow these links for more details:
 http://www.microsoft.com/technet/security/bulletin/ms04-010.mspx 

 Risk factor : High";


 script_description(english:desc["english"]);

 summary["english"] = "Checks for MS04-010";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);

 script_dependencies("netbios_name_get.nasl",
                     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
                     "SMB/domain","SMB/transport");

 script_require_ports(139, 445);
 exit(0);
}

# start script
include("smb_nt.inc");
include("misc_func.inc");

port = get_kb_item("SMB/transport");
if(!port)port = 139;

access = get_kb_item("SMB/registry_full_access");
if(!access)exit(0);                             


key = "SOFTWARE\Microsoft\MSNMessenger";
item = "InstallationDirectory";

value = registry_get_sz(item:item, key:key);    
if (!value) exit(0);                           


key = "SOFTWARE\Classes\Installer\Products\C838BEBA7A1AD5C47B1EB83441062011";
item = "Version";
value = registry_get_sz(item:item, key:key);
if (!value) exit(0);
if (egrep(string:value, pattern:"^60[01]*")) {
    if (egrep(string:value, pattern:"^600")) security_hole(port);
    if (egrep(string:value, pattern:"^60100([0-9a-c]|d[0-2])")) security_hole(port);
}    

exit(0);
