#
# (C) Tenable Network Security
#
# Ref: http://www.microsoft.com/technet/security/bulletin/ms03-037.mspx

if(description)
{
 script_id(11832);
 script_bugtraq_id(8534);
 script_cve_id("CAN-2003-0347");
 
 
 script_version("$Revision: 1.6 $");

 name["english"] = "Visual Basic for Application Overflow";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Microsoft Visual Basic for Applications
which is vulnerable to a buffer overflow when handling malformed documents.

An attacker may exploit this flaw to execute arbitrary code on this host, by
sending a malformed file to a user of the remote host.

Solution : See http://www.microsoft.com/technet/security/bulletin/ms03-037.mspx
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of vbe.dll and vbe6.dll";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/WindowsVersion",
		     "SMB/registry_access");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_nt.inc");
if ( ! get_kb_item("SMB/registry_access") ) exit(0);



rootfile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows NT\CurrentVersion", item:"PathName");
if(!rootfile)
{
 exit(0);
}
else
{
 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:rootfile);
 itircl =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1\system32\itircl.dll", string:rootfile);
}




function get_ver(filename)
{
name 	=  kb_smb_name();
login	=  kb_smb_login();
pass  	=  kb_smb_password();
domain 	=  kb_smb_domain();
port    =  kb_smb_transport();
if(!port) port = 139;



if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);



r = smb_session_request(soc:soc, remote:name);
if(!r)exit(0);

prot = smb_neg_prot(soc:soc);
if(!prot)exit(0);

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain, prot:prot);
if(!r)exit(0);

uid = session_extract_uid(reply:r);



r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
tid = tconx_extract_tid(reply:r);
if(!tid)exit(0);

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:filename);
if ( fid ) 
 {
 v = GetFileVersion(socket:soc, uid:uid, tid:tid, fid:fid);
 return v;
 }
 return NULL;
}



a = get_ver(filename:itircl);
if(a)
{
 # Fixed in 5.2.3790.80
  num = split(a, sep:".", keep:FALSE);
  if ( int(num[0]) < 5 ||
       ( int(num[0]) == 5 && int(num[1]) < 2) ||
       ( int(num[0]) == 5 && int(num[1]) == 2 && int(num[2]) < 3790 ) ||
       ( int(num[0]) == 5 && int(num[1]) == 2 && int(num[2]) == 3790 && int(num[3]) < 80 ))
        security_hole(kb_smb_transport());
        
  
}
